<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Cant List Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Seznam převýšení</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Seznam převýšení</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!--Project Data-->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední uprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor"/>
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <xsl:for-each select="HorizontalAlignment[*/CantAlignment]">
                                    <table class="margin" cellpadding="1">
                                        <tr>
                                            <th align="right" lang="en"><br/>Směrové řešení:&#xa0; </th>
                                            <td align="left" valign="bottom"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Směrové Popis:&#xa0; </th>
                                            <td align="left"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Směrové Styl:&#xa0; </th>
                                            <td align="left"><xsl:value-of select="@style"/></td>
                                        </tr>
                                        <!-- Cant Point Data -->
                                        <xsl:for-each select="Superelevation/CantAlignment[Cant/CantPoint]">
                                            <tr>
                                                <xsl:choose>
                                                    <xsl:when test="//@linearUnits = 'Imperial'">
                                                        <th class="underline" lang="en" valign="bottom">Staničení</th>
                                                        <th class="underline" lang="en" valign="bottom">Převýšení<br/>(in)</th>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <th class="underline" lang="en" valign="bottom">Staničení</th>
                                                        <th class="underline" lang="en" valign="bottom">Převýšení<br/>(mm)</th>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </tr>
                                            <xsl:for-each select="Cant[position() != last()]">
                                                <xsl:for-each select="CantPoint">
                                                    <tr>
                                                        <td align="right" style="white-space:nowrap;">
                                                            <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                                                        </td>
                                                        <xsl:choose>
                                                            <xsl:when test="@leftCant != 0">
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(@leftCant))"/>
                                                                </td>
                                                            </xsl:when>
                                                            <xsl:when test="@rightCant != 0">
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(@rightCant))"/>
                                                                </td>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(0))"/>
                                                                </td>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </tr>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jedno směrové řešení v poli <em>Zahrnout</em> v dialogu
                <em>Nástroje &gt; XML Výpisy &gt; Geometrie</em>.
            </p>
            <p class="normal1" lang="en">
                Pro tento výpis také musíte zapnout volbu <em>Včetně převýšení</em> a vybrat buď  
                <em>Vše</em> nebo <em>Aktivní</em>.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2009 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
